
#define shellprintinclude /*so other includes can tell if we've been loaded*/


#if MACVERSION
	#if TARGET_API_MAC_CARBON == 1
	#include <PMApplication.h>
	#include <PMDefinitions.h>
	//#include <PMCore.h>
	#else	
	#include <Printing.h>
	#endif
		
#endif

#if	WIN95VERSION

#endif


typedef struct typrintinfo {
	
	Rect margins; /*the margins we're enforcing to calculate paperrect*/
	
	Rect paperrect;

	long scaleMult;

	long scaleDiv;
	
	short ctpages; /*the number of pages in the document being printed*/
	
	#if MACVERSION

		#if TARGET_API_MAC_CARBON == 1
		GrafPtr	printport;
		PMPrintSession 	printhandle;
		PMPageFormat	pageformat;
		PMPrintSettings	printsettings;
		Rect			pagerect;
		#else
		
		TPPrPort printport;

		THPrint printhandle; /*a handle to the machine's print record*/
		#endif
	#endif

	#ifdef WIN95VERSION
	
		HDC printport;

		PAGESETUPDLG pagesetupinfo;

	#endif
	} typrintinfo;


extern typrintinfo shellprintinfo;


/*prototypes*/

extern boolean shellinitprint (void); /*shellprint.c*/

extern boolean shellpagesetup (void);

extern boolean shellprint (WindowPtr, boolean);

extern boolean iscurrentportprintport ();

extern boolean isprintingactive ();

extern boolean getprintscale (long * scaleMult, long * scaleDiv);